/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.wsrr;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistryList;
import filenet.vw.toolkit.admin.property.wsrr.VWConfigWSRRRegistryListPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VWConfigWSRRInfoPanel
extends JPanel {
    private VWWSRRRegistryList m_WSRRRegistryList = null;
    private Frame m_parentFrame = null;
    private VWSession m_vwSession = null;
    private boolean m_bChanged = false;
    private VWConfigWSRRRegistryListPanel m_WSRRRegistryListPanel = null;

    public VWConfigWSRRInfoPanel(Frame parentFrame, VWSessionInfo sessionInfo, VWAttributeInfo vwAttributeInfo) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_vwSession = sessionInfo.getSession();
            this.m_WSRRRegistryList = new VWWSRRRegistryList(this.m_vwSession, vwAttributeInfo);
            this.createControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_WSRRRegistryListPanel.hasChanged();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (bSuccess && this.m_WSRRRegistryListPanel.hasChanged()) {
                bSuccess = this.m_WSRRRegistryListPanel.update();
                this.m_bChanged = true;
            }
            if (this.m_bChanged && bSuccess) {
                this.m_WSRRRegistryList.updateAttribute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public void createControls() {
        try {
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.m_WSRRRegistryListPanel = new VWConfigWSRRRegistryListPanel(this.m_parentFrame, this.m_WSRRRegistryList);
            this.add(this.m_WSRRRegistryListPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_WSRRRegistryList != null) {
            this.m_WSRRRegistryList.releaseResources();
            this.m_WSRRRegistryList = null;
        }
        this.removeAll();
    }

    private void stopEditing() {
        if (this.m_WSRRRegistryListPanel != null) {
            this.m_WSRRRegistryListPanel.stopEditing();
        }
    }
}

